<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(__('Offline')); ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fa;
            color: #343a40;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            text-align: center;
        }

        .container {
            max-width: 400px;
            padding: 20px;
            border-radius: 8px;
            background-color: #fff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        h1 {
            color: #dc3545;
        }

        p {
            margin-bottom: 20px;
        }

        .refresh-btn {
            padding: 10px 20px;
            border: none;
            background-color: #007bff;
            color: #fff;
            font-size: 16px;
            border-radius: 4px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        .refresh-btn:hover {
            background-color: #0056b3;
        }
    </style>
</head>

<body>
    <div class="container">
        <h1><?php echo e(__('Offline')); ?></h1>
        <p><?php echo e(__('You are currently offline.')); ?></p>
        <p><?php echo e(__('Please check your internet connection and try again.')); ?></p>
        <button class="refresh-btn" onclick="location.reload()"><?php echo e(__('Try Again')); ?></button>
    </div>
</body>

</html>
<?php /**PATH /home/tanvirto/public_html/core/resources/views/pwa/offline.blade.php ENDPATH**/ ?>